// js/trainer_chat.js
document.addEventListener('DOMContentLoaded', () => {
    const chatArea = document.getElementById('chatArea');
    const chatForm = document.getElementById('chatForm');
    const msgInput = document.getElementById('msgInput');
    const sessionId = document.getElementById('sessionId').value;
    const typingIndicator = document.getElementById('typingIndicator');

    let isProcessing = false;

    // Scroll to bottom on load
    scrollToBottom();

    chatForm.addEventListener('submit', async (e) => {
        e.preventDefault();
        const text = msgInput.value.trim();
        if (!text || isProcessing) return;

        // UI: Add User Message
        appendMessage('trainee', text);
        msgInput.value = '';
        msgInput.focus();
        isProcessing = true;

        // UI: Show Typing
        showTyping(true);

        try {
            const response = await fetch('chat_endpoint.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({
                    action: 'send_message',
                    session_id: sessionId,
                    message: text
                })
            });

            const data = await response.json();

            showTyping(false);

            if (data.success) {
                appendMessage('bot', data.reply);
            } else {
                appendMessage('bot', "Error: " + (data.error || "Connection failed"));
            }

        } catch (err) {
            showTyping(false);
            appendMessage('bot', "Network Error: " + err.message);
            console.error(err);
        } finally {
            isProcessing = false;
        }
    });

    function appendMessage(sender, text) {
        const div = document.createElement('div');
        div.className = `chat-message chat-message-${sender}`;
        // Basic escaping handled by textContent, but if we want markdown/html support we need a parser.
        // For security, strict textContent for now, or simple replacement.
        div.innerHTML = text.replace(/\n/g, '<br>');

        // Insert before typing indicator
        chatArea.insertBefore(div, typingIndicator);
        scrollToBottom();
    }

    function showTyping(show) {
        if (show) {
            typingIndicator.classList.remove('d-none');
            chatArea.appendChild(typingIndicator); // Move to bottom
        } else {
            typingIndicator.classList.add('d-none');
        }
        scrollToBottom();
    }

    function scrollToBottom() {
        chatArea.scrollTop = chatArea.scrollHeight;
    }
});
