<?php
// includes/trainer_bot_functions.php
require_once __DIR__ . '/db.php';

/* --- Global Configuration --- */

// Hardcoded Training Instructions - EDIT THIS PER YOUR NEEDS
define('GLOBAL_TRAINING_INSTRUCTIONS', <<<EOT
USE THE ACCURATE INFORMATION FROM THIS MANUAL, DONT ADD OR REMOVE ANY INSTRUCTION BY YOUR THINKING
We Are Death Squad Gaming Community and we are only here for counter strike1.6 server, dont try to promote any other games.
we have 3 servers, public, afk and deathmatch. 
ip for each server is:
    PUBLIC: 149.202.87.35:27015
    AFK: 149.202.87.35:27016
    DEATHMATCH: 149.202.87.35:27018

DONT REPLY TO ANY IRRELEVANT QUESTIONS NOT RELATED  TO THIS COMMUNITY AND SERVER

Do not use any special character, bold, italic, underline, etc. in your response. and explain the commands briefly with rules, why we do that, command usage according to the manual given below:
never ask "Would you like to practice using these commands?" bcs you are training in chat not in server
dont re share the instruction again, unless the user ask anything for it. once every command has done ask user if he has any question or not. and if not and he is satisfied request him to proceed to the mock test.
DSGC ADMINISTRATOR MANUAL

As an Administrator you are responsible for the players that are playing. 
This means helping them against those who break the rules. The players of this Community will ask questions, they are curious, so it’s your responsibility to answer them and Guide them professionally.
It is mandatory to respond to the player’s reports and check for anything that is considered as rule breaking. If you are unclear about any question, rule, or anything that happens in the server it is advised to reach out to your seniors, uppers and ask them for help.
If you are joining DSGC, you must not be an admin at any other server.
Violation of any policy may result in suspension or permanent removal from the server too.
Even if you are admin, you must not misuse your powers or disrespect any normal players.
You can’t question CM seniors. If you have a serious problem, seek help or guidance from founders and creators and don’t abuse or confront them directly.
You will get dropped from the adminship if you stay inactive for 3 or more weeks without letting us know (also depends on our decision).
Staying AFK, being spectator and not giving attention to the server (ignoring SV and doing other work without letting in-game seniors know and for too long) will result in GT deduction.
Direct wrong bans can result in direct suspension and for that time period you will have no access, and no apologies, access will be given back once you complete your punishment.
Disrespecting religion will result in direct fire from CM, no matter if you disrespect any religion.
You must not leak anything from admin chats as this must remain between you and admins. Doing so may result in you getting kicked for a specific time period or may be permanent.
Slapping in a disrespectful way or for your self-satisfaction may also result in suspension.
Making fun of seniors in servers especially is strictly prohibited.
Ignoring players reporting for sake of your score is not permissible; however, ignoring someone for example they are teasing you and no need for gag, you can either friend zone them or ignore them is permissible only.
You must consider server problems as your own problem as you already promised us to stay loyal in exchange for access.
Promoting favoritism or preferring rules over your friends will not be appreciated and can also result in you getting some punishment.
Kicking AFK when the server is not full is not permissible as it will only decrease server rush. You can get free kills, it’s allowed but if you or someone has problems, you can transfer them to the spectator.
You must be voting fairly on fb when someone post adminship form and before we accept it. Changing your votes on the basis of favoritism or friendship will result in you losing the right to vote for admins.
You are not allowed to strafe or SGS or BGS. You can do them once you have VIP won, purchased or allowed to do or you are a server senior.
Bhop abuse is prohibited. If someone will show that they have a problem, stop that immediately even if you have purchased it.
Admins are also not allowed to use any kind of hacks except steam linking. Only if you have a graphical problem and in that case you may be asked to drop a demo with scan.
Seniors can make fun in admin chat in order to make each other and you laugh to avoid all day tensions. Keep it as a joke and never take it personally nor abuse them ever. Consider them your brothers as it will increase love and respect between you and them.
Never misbehave with anyone and forget about personal things in CM. When you are admin, you are actually server representative so behave nicely and stay formal all the time.
Asking for promotion is not allowed, when we realize about promotion, we will promote you. Asking for it has potential risk you getting removed from CM
Act mature - don’t be childish even for those who are.
Never misuse your powers on players, or admins even if it’s a joke.

DSGC ADMINISTRATOR MANUAL

Setting up your Admin Password.

Setinfo _pw
Admin pw is important for those who got accepted to our community, using this password you will get access to use your admin power and privileges.
Setting up the password is used by a command which is written inside the console before joining into the server, and you do it only one time and you are set to go!
The command is • setinfo _pw “your password here”
Let’s say that your password is - freak213
You open your cs. Then you open your console and type the command setinfo _pw “freak213” Then you press enter and you are ready to go. 

A small reminder - Setting up The admin pw is done before joining The Server! And it’s done one Time only.

Chats
Small notice - There is no space after @ when using The Y (which is the white chat on the screen) or U (which is the admin chat).
Y@ (general Chat) press Y for General chat and start a message with @ to write in white chat for all the players.
This is used to communicate with the players, also to warn those who are camping in Base after 25 seconds. And To warn T to play C4 and not to camp. We also warn the strafers, abusers, wall climbers. Etc.
U@ press U (which is the team chat) and start your message with @ To write on the admin chat.

amx_say 
This is a command that is used to type a message for everyone in the General chat. And you can use it to warn campers wall climbers and strafers, 
And it can be easily spammed a few times so that everyone can see it.
EXAMPLE- open console and Type amx_say Leave Base in 25 seconds or you will get slayed.

amx_psay
This is a command that is used to type a private message to a player that only he can see.
EXAMPLE - open console and Type amx_psay “xi Nutella.” “How are you my bro?”

LET’S START WITH BASIC COMMANDS

 amx_who
This command is used to see all the players that are playing at the moment inside the server, you get the players’ names, and to the right side you can see the player's Steam ID. 
EXAMPLE - xi Nutella.  STEAM_1:0:865760318 423 No Noz
Photo for EXAMPLE - https://imgur.com/a/zGrqJPH

amx_last
This command will show you the last 10 players that left the server, with their names and their Steam ID and Their IP. Picture as an EXAMPLE - https://imgur.com/a/1kae6kw 
So if a player was hacking and he left the server before you get the chance to ban him, you use the amx_last command to get his details which is his exact nick or his steam ID. 
Once you got his Steam ID - or Nick. You will use the amx_addban command to ban him.

amx_showip
This command will show You the IP of all the players.
Photo for EXAMPLE - https://imgur.com/a/lqUEtav 

amx_kick
This command is used to kick a player from the server for some reason.
The reason can be - The player is AFK and the server is full - so we use the kick CMD like this - amx_kick “xi Nutella.” “AFK server is full”
We also use it if the player is having a huge amount of lag - amx_kick “xi Nutella” “fix your lag”

amx_kickmenu
This command is also used to kick players. 
Kick player (you will see list of players from 1 to 8, 9 is next page, 0 is previous) Select player and player will be kicked. No reason will be given so don’t use this one as you can’t give reason only in “emergency”
Photo for EXAMPLE - https://imgur.com/a/24w2XhA 

amx_gag
This command is used To gag a player for a specific amount of time. Reasons are if the player is abusing other players , or talking about political stuff that are not related to The Game , we use the gag CMD to gag them. So the CMD is used like this amx_gag “player nick” “Time (with seconds)”
The time when using the gag CMD is always and only within seconds. So let’s say you want to gag a player for 5 mins you put at the time 300, 10 mins gag is 600, 15 mins gag is 900.

EXAMPLE - amx_gag “xi Nutella.” “300” like that you will gag the player for 5 mins.
10 mins gag - amx_gag “xi Nutella” “600”
15 mins gag - amx_gag “xi Nutella” “900”

amx_gagmenu
This command is used also to gag a player if he abuses or for any reason that was explained on the gag CMD
So you type amx_gagmenu
and you will get a list of the names of the players from 1 to 6 is the player to choose , 9 is next , 0 is previous and 8 is the duration - Time.
Photo for EXAMPLE - https://imgur.com/a/5HnD3DQ 


amx_slap
This command is used to slap the players who are camping in base after 25 seconds round start.
We also use it to slap the wall climbers, and also to warn the strafers. 
This command is used with no damage slap and also with damage slap.
The 0 damage slap is used like this - amx_slap “xi Nutella”
Like this you will slap the player with 0 damage.
The + damage command is used like this - amx_slap “xi Nutella” “5” - Like this you will slap the player with 5 damage. That means if his health is 100, slapping him with 5 damage will make it 95 , his HP will go down.
amx_slap “player nick” - amx_slap “player nick” “damage”

amx_slapmenu
This command is used to slap the players and it can be used like this. amx_slapmenu , you will get a list of players from 1 to 7 is the players to choose , 9 is next , 0 is previous , 8 is damage.
Photo for EXAMPLE - https://imgur.com/a/NvYfz5w 

amx_slay
This command is used to slay the players who don't respect the rules, such as - Strafers - wall climbers - Base campers. 
We use this command, if the player was warned about not doing something such as wall climbing and he is still wall climbing, or base camping after 25 seconds and he was warned, and still camping he gets slayed. Also for strafers who were warned and still strafing, they get slayed. 
The command is used like this - amx_slay “player nick”
EXAMPLE - amx_slay “xi Nutella.

amx_nick
This command is used to change a player's nickname.
And it’s used like this - amx_nick “The current nick” “The new nick”
Reasons for changing the nick of a player is -
1- If a player is using an admin nick.
2- If a player is using an abusive nickname.
3- If a player enters the server with hosting nicks.
4- If a player enters the server with nick <warrior> player, or any other nick that is related to this one must be changed.
5- If a player is using political nick such as “free Palestine, or fuck Israel. Must be changed also.
6- Any nick that is insulting any religion. All religions are respected in our community.
The new nick that you will give for those players must always be a DS related nick. Such as (DS-player-DS-Batman-DS-pro), “DS” must be always present in their names.
EXAMPLE - amx_nick “<warrior> player” “DS-PLAYER”
amx_nick “fuck you” “DS-BATMAN”
amx_nick “free Palestine” “DS-PRO”


amx_ban
This command is used to ban a player either permanent ban or temporary ban, this depends on the reason.
Permanent ban reasons - 
Wallhack - permanent
Aim - permanent
Speed hack - permanent
CFG hacks - permanent
Bhop script - permanent
Scout/AWP CROSSHAIR - permanent
Religion abuse - permanent
For all of the above reason’s ban is permanent.
Advertising
And the command is used like this - amx_ban “player nick” “duration” “reason”
EXAMPLE - amx_ban “xi Nutella.” “0” “Wallhack”
For permanent ban the duration - Time is always 0.
Now The Temporarily ban reasons - 
1. Strafing/BGS - 300 - which is 5 hours.
2. Camp continuously after warn, slap, slay and kick - 5 to max 30 mins.
3. Wall climb after warn, slap, slay and kick - 5 to max 30 mins.
For all of the above reasons, the ban is temporary.
EXAMPLE - amx_ban “xi Nutella.” “many warnings and still strafing” “300” - like this you will ban the player for 5 hours if he was slapped, slayed, warned many times not to strafe and he keeps strafing.
EXAMPLE 2 - if the players keeps camping after warn slap slay and kick you can ban him 5 - to 30 mins max. 
amx_ban “xi Nutella” “5” “keeps camping after warning” like this he will be banned for 5 mins.

ESP
ESP is a tool which allows you to easily see if a player is using WH (Wallhack). When you are in spec mode dead or in the spectator area and this tool is “activated” you will see other players on your screen, red indicates it’s a player in the Terrorist team, blue indicates it’s a player from Counter Terrorist team

amx_banmenu
This command is also used to ban players, and it's used like this , amx_banmenu , you will get a list of players from 1 to 7 is the player to choose, 9 is next , 0 is previous , 8 is the duration.
After choosing the player and the duration you need to type the reason then click enter and the player is banned. Make sure to always type a good reason.
Photo for EXAMPLE - https://imgur.com/a/AVLMj3K 


amx_addban
This command is used to ban a player that was hacking and you were about to ban him but he left the server before you could do it. So we use it to add ban the player. This way he won’t be able to come back to the server.
amx_addban “player nick - or Steam ID” “Time-duration” “reason”
Now the addban CMD duration is different from the ban CMD. in the addban CMD we always use “9999999” in the duration - time, for permanent ban.
EXAMPLE - amx_addban “xi Nutella.” “9999999” “speedhack”- like that the player will be added to the ban list and be banned perm.
if you don’t remember the player nick - or the player nick doesn’t work for you , you need to use the amx_last command to see the last 10 players that left the server , and take The player steam ID which will be to the right to the player nick and it’s like this - STEAM_1:0:865760318
EXAMPLE - amx_addban “STEAM_1:0:865760318” “9999999” “Wallhack”
Now players in the game will always report a player in the admin chat and you must respond to their reports and deal with them , always make sure to spectate the reported player from 3 to 6 rounds before making your decision ( like if he is clean , or not ) . Always before banning a player you must be 100% sure that the player is truly hacking.
If you are not sure whether the player is hacking or not after spectating him from 3 to 6 rounds, you can use the /scan command which will be explained down.

/scan (War God Scan)
War god scan is an important application which helps us to identify if the player is hacking or not, if you got a report about a player or you suspected a player, and you spectated him from 3 to 6 rounds and you are not sure if he is hacking or not, you can use the war god scan to confirm.
And for that you need to press Y (the general chat) then start a message with /scan then the player nick. 
Also another way to do it, you open your console and type say /scan then steam id of the player.
to get the steam id of the player that you are going to scan you need to use the amx_who command to see all the players that are playing on server with their steam id’s and nick, the player steam id will be to the right of his name you copy it and type in console say /scan STEAM_0:1:486969393 once you type this the player will be automatically transferred to the spectators and entered the war god scan mode , if the player left the server after entering the scan mode he “will be banned automatically”
after that the player is transferred to the spectators to scan mode you need to ask him to do a scan to confirm if he is hacking or not, if the player doesn’t know how to do the scan you need to explain to him with patience, tell him to type in the general chat /wcd and he will get a full explanation about how to do the scan.
When he is done scanning he should tell you that he is done and you need to go to - https://www.wargods.ro/wcd/download.php 
War god scan site, you will have to click the third button in the top of the screen to the middle which called “WCDSCANS”
Once you clicked it you will get a list of names of the players that recently did a war god scan, some of them will be marked with blue color and some of them will be marked with red color. 
You identify your player nick that u asked him to scan on the scan list inside the site, if it’s marked with Blue that means he is clean and not using any kind of hacks. 
And if it’s marked with red that means he is hacking, you can click the name of the player on the list to enter and see the report, and you will see a Report word with the program he is using, cheat. For example (Report: OpenGL32 Cheat). 

EXAMPLE FOR RED SCAN (unclean scan) - https://www.wargods.ro/wcd/report.php?id=2781939
EXAMPLE FOR BLUE SCAN (clean scan) - https://www.wargods.ro/wcd/report.php?id=2781943 
 
Now if the player scan is clean (Blue)! That means he can go back and play, and you need to transfer him back from the war god scan mode. So you open console and type say /clean steam id
EXAMPLE - say /clean STEAM_0:1:486969393 
Like that he will be out of scan mode and he can play.
Now if the player scan is unclean (red)! That means you need to ban the player permanently. and to do that you open console and type say /clean steam id , he will be out of the scan mode , then you will use the ban CMD which is amx_ban “nick-steam id” “duration” “reason”
EXAMPLE - say /clean STEAM_0:1:486969393
Then amx_ban “STEAM_0:1:486969393” “0” “Wallhack”
in case of that you asked someone for a scan and he don’t reply and don’t leave , and didn’t scan after 10 to 13 mins you need to ban him manually permanently  with reason “post demo on fb group for unban”
So you open console type say /clean STEAM_0:1:486969393
Then use the ban CMD - amx_ban “STEAM_0:1:486969393” “0” “post demo on fb group for unban”

amx_spectate
amx_spectate is a command that is used when you want to spectate a player that has been reported or a player that you suspected for cheating. Using this command will make you go to spectate mode as a ghost, meaning you will be spectate mode but the players will see you in T team or in CT team. 
To activate it you type in console amx_spectate to inactivate it you type again amx_spectate in console and you are out of spectate mode.

amx_teammenu
This command is used to move a player to teams or to spectators, you type it once, and you will have a menu on your screen.
Number 1-7 is the player you want to move.
Number 8 will be your action where you want to move a player (terrorist, counter terrorist, spectator) When you press 8 you toggle between terrorist, counter terrorist and spectators.
Photo for EXAMPLE - https://imgur.com/a/uU46NHR 

amxmodmenu
amxmodmenu - is the command that contains all of the above commands that was explained before. You can use the amxmodmenu and easily use any other command from it.
Photo for EXAMPLE - https://imgur.com/a/7TrwAlB 


HOW TO CHECK A PLAYER DEMO.
Checking players' demos is also an important thing, when a player is banned for not giving a war god scan and asked to post his demo on a FB group. He will go and upload his Demo on mediafire and post the link on the FB Group through the unban forum.
You will go to that link and download the player Demo to your pc. Once it’s done go to your downloads and you will find the Demo which name would be “DS-PUBLIC.dem”, you will grab that file and go to your cstrike folder and drag it into this folder “cstrike” (C:\Program Files (x86)\Steam\steamapps\common\Half-Life\cstrike) 
After you have done that, you will open your CS and open your console and type viewdemo here is the demo name. (viewdemo DS-PUBLIC.dem). And you will be able to watch his Demo and decide if he is clean or not.

Test
When you are done with your training, you must prove that you understand the rules and know the commands so you will be tested.

Our FB Group
https://www.facebook.com/groups/DSGaMinGCM
EOT
);


/* --- Material Logic (Deprecated/Stubbed) --- */

// Removed uploadTrainingPDF, createManualMaterial, getAllTrainingMaterials

/* --- Trainee Management --- */

function createTrainee($nick, $realName, $experience, $password, $skillLevel = 'basic') {
    $pdo = getDB();
    // Check duplicate
    $stmt = $pdo->prepare("SELECT id FROM trainees WHERE trainee_nick = ?");
    $stmt->execute([$nick]);
    if ($stmt->fetch()) {
        return ['success' => false, 'error' => "Nickname already exists."];
    }

    $hash = password_hash($password, PASSWORD_DEFAULT);
    $stmt = $pdo->prepare("INSERT INTO trainees (trainee_nick, real_name, experience_years, password_hash, skill_level) VALUES (?, ?, ?, ?, ?)");
    
    try {
        $stmt->execute([$nick, $realName, $experience, $hash, $skillLevel]);
        return ['success' => true, 'id' => $pdo->lastInsertId()];
    } catch (PDOException $e) {
        return ['success' => false, 'error' => $e->getMessage()];
    }
}

function authenticateTrainee($nick, $password) {
    $pdo = getDB();
    $stmt = $pdo->prepare("SELECT * FROM trainees WHERE trainee_nick = ? AND status = 'active'");
    $stmt->execute([$nick]);
    $trainee = $stmt->fetch();

    if ($trainee && password_verify($password, $trainee['password_hash'])) {
        // Update last login
        $pdo->prepare("UPDATE trainees SET last_login = NOW() WHERE id = ?")->execute([$trainee['id']]);
        return $trainee;
    }
    return false;
}

function getTrainee($id) {
    $pdo = getDB();
    $stmt = $pdo->prepare("SELECT * FROM trainees WHERE id = ?");
    $stmt->execute([$id]);
    return $stmt->fetch();
}

/* --- Session Logic --- */

function getGlobalMaterialId() {
    $pdo = getDB();
    // Check for existing dummy
    $stmt = $pdo->query("SELECT id FROM training_materials WHERE filename = 'global_manual' LIMIT 1");
    $id = $stmt->fetchColumn();
    if ($id) return $id;
    
    // Create dummy if not exists to satisfy FK constraints
    try {
        $pdo->prepare("INSERT INTO training_materials (filename, original_name, file_path, uploaded_by, status) VALUES ('global_manual', 'Global Manual', 'hardcoded', 'system', 'active')")->execute();
        return $pdo->lastInsertId();
    } catch (PDOException $e) {
        // Fallback or error logging
        return 0;
    }
}

function startTrainingSession($traineeId, $materialId = 0) { 
    $pdo = getDB();
    $trainee = getTrainee($traineeId);
    
    // Safety check: if trainee not found (deleted?), use defaults or fail gracefully.
    $skillLevel = 'basic';
    if ($trainee) {
        $skillLevel = $trainee['skill_level'];
    } else {
        // Log this odd case: session exists but trainee DB record missing
        error_log("Warning: startTrainingSession called for missing trainee ID: $traineeId");
    }

    // Close any previous in-progress sessions
    $pdo->prepare("UPDATE training_sessions SET status = 'paused' WHERE trainee_id = ? AND status = 'in_progress'")->execute([$traineeId]);

    // Ensure we have a valid material ID to satisfy DB constraints
    $globalId = getGlobalMaterialId();

    $stmt = $pdo->prepare("INSERT INTO training_sessions (trainee_id, material_id, skill_level, status) VALUES (?, ?, ?, 'in_progress')");
    $stmt->execute([$traineeId, $globalId, $skillLevel]); 
    return $pdo->lastInsertId();
}

function getActiveSession($traineeId) {
    $pdo = getDB();
    // Fetch session and join with materials to get name, or fallback
    // We also calculate progress here if needed, or rely on stored progress_percentage?
    // The previous implementation used stored progress_percentage in tests? 
    // Wait, the previous code showed `progress_percentage` column in `training_sessions` table.
    
    // Let's rejoin with training_materials just to get the name if it exists, otherwise manual fallback
    $stmt = $pdo->prepare("SELECT ts.*, COALESCE(tm.original_name, 'General Admin Training') as original_name 
                           FROM training_sessions ts 
                           LEFT JOIN training_materials tm ON ts.material_id = tm.id
                           WHERE ts.trainee_id = ? AND ts.status = 'in_progress' 
                           ORDER BY ts.started_at DESC LIMIT 1");
    $stmt->execute([$traineeId]);
    $session = $stmt->fetch();
    
    if ($session) {
        // Calculate progress based on messages count or just use a dummy value/stored value?
        // The dashboard uses 'progress_percentage'. Let's ensure it's set.
        if (!isset($session['progress_percentage'])) {
             // Basic estimation: count messages from bot? 
             // faster to just default to 0 if null
             $session['progress_percentage'] = 0;
        }
    }
    
    return $session;
}

function addChatMessage($sessionId, $sender, $message, $type = 'instruction') {
    $pdo = getDB();
    $stmt = $pdo->prepare("INSERT INTO chat_messages (session_id, sender, message, message_type) VALUES (?, ?, ?, ?)");
    $stmt->execute([$sessionId, $sender, $message, $type]);
    return $pdo->lastInsertId();
}

function getSessionChatHistory($sessionId, $limit = 50) {
    $pdo = getDB();
    $stmt = $pdo->prepare("SELECT * FROM chat_messages WHERE session_id = ? ORDER BY id DESC LIMIT ?");
    $stmt->bindValue(1, $sessionId, PDO::PARAM_INT);
    $stmt->bindValue(2, $limit, PDO::PARAM_INT);
    $stmt->execute();
    return array_reverse($stmt->fetchAll());
}

/* --- Stats & Admin --- */

function getAllTrainees() {
    $pdo = getDB();
    return $pdo->query("SELECT * FROM trainees ORDER BY created_at DESC")->fetchAll();
}

function deleteTrainee($id) {
    $pdo = getDB();
    // Delete associated sessions/tests/messages first (CASCADE usually handles this, but let's be safe if not)
    $pdo->prepare("DELETE FROM training_sessions WHERE trainee_id = ?")->execute([$id]);
    $pdo->prepare("DELETE FROM test_attempts WHERE trainee_id = ?")->execute([$id]);
    
    $stmt = $pdo->prepare("DELETE FROM trainees WHERE id = ?");
    return $stmt->execute([$id]);
}

function updateTrainee($id, $nick, $realName, $experience, $skill, $password = null) {
    $pdo = getDB();
    
    // Check duplicate nick if changed
    $stmt = $pdo->prepare("SELECT id FROM trainees WHERE trainee_nick = ? AND id != ?");
    $stmt->execute([$nick, $id]);
    if ($stmt->fetch()) {
        return ['success' => false, 'error' => "Nickname already exists."];
    }

    $sql = "UPDATE trainees SET trainee_nick = ?, real_name = ?, experience_years = ?, skill_level = ? WHERE id = ?";
    $params = [$nick, $realName, $experience, $skill, $id];

    if ($password) {
        $sql = "UPDATE trainees SET trainee_nick = ?, real_name = ?, experience_years = ?, skill_level = ?, password_hash = ? WHERE id = ?";
        $params = [$nick, $realName, $experience, $skill, password_hash($password, PASSWORD_DEFAULT), $id];
    }

    try {
        $pdo->prepare($sql)->execute($params);
        return ['success' => true];
    } catch (PDOException $e) {
        return ['success' => false, 'error' => $e->getMessage()];
    }
}

function getTraineeTestHistory($traineeId) {
    $pdo = getDB();
    // Removed Join on materials - might need to adjust Select if material_name relied on
    $stmt = $pdo->prepare("SELECT ta.*, 'Global Training' as material_name 
                           FROM test_attempts ta 
                           WHERE ta.trainee_id = ? 
                           ORDER BY ta.started_at DESC");
    $stmt->execute([$traineeId]);
    return $stmt->fetchAll();
}

/* --- Test Logic --- */

function generateTestQuestions($materialId, $difficulty = 'basic') {
    $pdo = getDB();
    
    // Global test (material_id = 0) handling
    // We need to resolve it to a real DB ID and ensure questions exist in DB so FK constraints work
    if ($materialId === 0) {
        $stmtM = $pdo->prepare("SELECT id FROM training_materials WHERE original_name = 'General Admin Certification'");
        $stmtM->execute();
        $realId = $stmtM->fetchColumn();
        
        // If material doesn't exist, create it (Safety check, should exist from submitTestAttempt logic/script, but self-healing is good)
        if (!$realId) {
             try {
                 $stmtI = $pdo->prepare("INSERT INTO training_materials (filename, original_name, file_path, upload_date, uploaded_by) VALUES ('global_cert', 'General Admin Certification', 'global_cert_path', NOW(), 1)");
                 $stmtI->execute();
                 $realId = $pdo->lastInsertId();
             } catch (Exception $e) {
                 // Fallback if uploaded_by fails
                 $stmtU = $pdo->query("SELECT id FROM users LIMIT 1");
                 $uid = $stmtU->fetchColumn() ?: 1;
                 $stmtI = $pdo->prepare("INSERT INTO training_materials (filename, original_name, file_path, upload_date, uploaded_by) VALUES ('global_cert', 'General Admin Certification', 'global_cert_path', NOW(), ?)");
                 $stmtI->execute([$uid]);
                 $realId = $pdo->lastInsertId();
             }
        }
        $materialId = $realId; // Use the real ID for queries
        
        // Check if questions exist
        $stmtQ = $pdo->prepare("SELECT COUNT(*) FROM test_questions WHERE material_id = ?");
        $stmtQ->execute([$materialId]);
        $count = $stmtQ->fetchColumn();
        
        // Define the 17 specific questions
        $globalQuestions = [
            [
                'q' => 'How to set your admin password correctly?',
                'options' => [
                    'Open Console -> setinfo _pw "yourpassword" -> Then Connect', 
                    'Connect to Server -> Type /login password in chat', 
                    'Open Console -> amx_password "yourpassword"', 
                    'Connect to Server -> Open Console -> setinfo _pw "yourpassword"'
                ],
                'correct' => 'Open Console -> setinfo _pw "yourpassword" -> Then Connect',
                'explanation' => 'You MUST set your password in the console BEFORE joining the server.'
            ],
            [
                'q' => 'When should you use Slap and Slay on players?',
                'options' => [
                    'Whenever you feel like it', 
                    'Only for rule breakers (Camping, Strafing) after a Warning', 
                    'Immediately when someone camps', 
                    'To punish bad players'
                ],
                'correct' => 'Only for rule breakers (Camping, Strafing) after a Warning',
                'explanation' => 'Slap/Slay are punishments used AFTER warning for specific rule violations like camping or strafing.'
            ],
            [
                'q' => 'A player nick "bot" is camping in T base for the last 5 rounds. What actions will you take?',
                'options' => [
                    'Ban him immediately', 
                    'Warn -> Slap -> Slay -> Kick -> Temp Ban (5-30m)', 
                    'Slap him every round', 
                    'Ignore him'
                ],
                'correct' => 'Warn -> Slap -> Slay -> Kick -> Temp Ban (5-30m)',
                'explanation' => 'Progressive punishment: Warn first, then Slap, then Slay, then Kick, and finally Temp Ban if he continues for 5 rounds.'
            ],
            [
                'q' => 'What is the command for slap with 0 damage?',
                'options' => ['amx_slap "name" 0', 'amx_slap "name"', 'amx_slap "name" damage=0', 'Both A and B'],
                'correct' => 'Both A and B',
                'explanation' => 'amx_slap "name" defaults to 0 damage. You can also explicitly type "0".'
            ],
            [
                'q' => 'What is the command to slay a player?',
                'options' => ['amx_kill "name"', 'amx_slay "name"', 'slay "name"', 'admin_slay "name"'],
                'correct' => 'amx_slay "name"',
                'explanation' => 'The command is amx_slay "name".'
            ],
            [
                'q' => 'A player nick "John" is abusing in chat. What will you do?',
                'options' => [
                    'Ban him', 
                    'Kick him', 
                    'Gag him', 
                    'Slap him'
                ],
                'correct' => 'Gag him',
                'explanation' => 'Abuse in chat is punished with amx_gag.'
            ],
            [
                'q' => 'How is time defined in the gag command?',
                'options' => ['Minutes', 'Seconds', 'Hours', 'Days'],
                'correct' => 'Seconds',
                'explanation' => 'Gag time is ALWAYS in seconds.'
            ],
            [
                'q' => 'How to gag John for 5 minutes?',
                'options' => ['amx_gag "John" 5', 'amx_gag "John" 300', 'amx_gag "John" 5m', 'amx_gag "John" 500'],
                'correct' => 'amx_gag "John" 300',
                'explanation' => '5 minutes * 60 seconds = 300 seconds.'
            ],
            [
                'q' => 'What are the rules for kick?',
                'options' => [
                    'Kick anyone you dislike', 
                    'Kick only AFK when server is full or highly lagging players', 
                    'Kick campers', 
                    'Kick strafers'
                ],
                'correct' => 'Kick only AFK when server is full or highly lagging players',
                'explanation' => 'Kick is primarily for AFK players when the server is full (to make space) or players with extreme lag.'
            ],
            [
                'q' => 'What are the rules for rename?',
                'options' => [
                    'New nick must contain "DS" prefix and be respectable', 
                    'Rename them to "Noob"', 
                    'Rename to "Admin_Rename"', 
                    'No rules'
                ],
                'correct' => 'New nick must contain "DS" prefix and be respectable',
                'explanation' => 'Renamed players must have "DS" in their name (e.g., DS-Guest).'
            ],
            [
                'q' => 'What is the Rename command?',
                'options' => ['amx_name "old" "new"', 'amx_nick "old" "new"', 'amx_rename "old" "new"', 'name "old" "new"'],
                'correct' => 'amx_nick "old" "new"',
                'explanation' => 'amx_nick is the command to change a player\'s name.'
            ],
            [
                'q' => 'How to get list of all current players in server?',
                'options' => ['status', 'amx_who', 'amx_list', 'list players'],
                'correct' => 'amx_who',
                'explanation' => 'amx_who shows the list of players with their Steam IDs and access info.'
            ],
            [
                'q' => 'How to use admin chat in server?',
                'options' => ['say_team @ message', 'U@ message', 'amx_chat message', 'All of the above'],
                'correct' => 'U@ message',
                'explanation' => 'Press U (Team Chat) then type @ followed by your message to chat with other admins.'
            ],
            [
                'q' => 'A player "Max" is playing weirdly (suspected Wallhack). What steps do you follow?',
                'options' => [
                    'Ban immediately', 
                    'Spectate 3-6 rounds -> /scan -> Check Result -> Clean or Ban', 
                    'Ask him if he hacks', 
                    'Kick him'
                ],
                'correct' => 'Spectate 3-6 rounds -> /scan -> Check Result -> Clean or Ban',
                'explanation' => 'Always spectate first (3-6 rounds) to confirm suspicion, then use /scan (WarGods) to verify.'
            ],
            [
                'q' => 'You spectated Max for 5 rounds. He leaves WITHOUT scanning. What do you do?',
                'options' => [
                    'Nothing', 
                    'Ban him permanently using amx_addban with reason "post demo"', 
                    'Temp ban him using amx_ban', 
                    'Report to senior'
                ],
                'correct' => 'Ban him permanently using amx_addban with reason "post demo"',
                'explanation' => 'Leaving to avoid scan = Permanent Ban. Since he left, use amx_addban with reason "post demo on fb group for unban".'
            ],
            [
                'q' => 'How to transfer any player from TS to CT?',
                'options' => ['amx_transfer', 'amx_teammenu', 'amx_move', 'amx_swap'],
                'correct' => 'amx_teammenu',
                'explanation' => 'amx_teammenu opens the menu to transfer players between teams.'
            ],
            [
                'q' => 'How to check a demo?',
                'options' => ['playdemo "name"', 'viewdemo "name"', 'watch "name"', 'demo_view "name"'],
                'correct' => 'viewdemo "name"',
                'explanation' => 'viewdemo allows you to watch the demo with controls (pause, speed up, etc).'
            ]
        ];


    if ($count < 17) {
        $pdo->prepare("DELETE FROM test_questions WHERE material_id = ?")->execute([$materialId]);
        $stmtIn = $pdo->prepare("INSERT INTO test_questions (material_id, question_text, question_type, options, correct_answer, explanation) VALUES (?, ?, 'mcq', ?, ?, ?)");
        
        foreach ($globalQuestions as $gq) {
            $stmtIn->execute([$materialId, $gq['q'], json_encode($gq['options']), $gq['correct'], $gq['explanation']]);
        }
    }
    
    // Fetch and return formatted
    $stmtF = $pdo->prepare("SELECT id, question_text, options, correct_answer as correct_answer, explanation FROM test_questions WHERE material_id = ? ORDER BY id ASC");
    $stmtF->execute([$materialId]);
    $rows = $stmtF->fetchAll();
    
    $finalQuestions = [];
    foreach ($rows as $r) {
        $decodedOptions = json_decode($r['options'], true);
        // Handle if options are not valid JSON (e.g. old data), though for Global we just inserted valid JSON.
        if (!is_array($decodedOptions)) {
             $decodedOptions = explode(',', $r['options']); // Fallback
        }
        
        $finalQuestions[] = [
            'id' => $r['id'],
            'question_text' => $r['question_text'],
            'question_type' => 'mcq',
            'options' => $decodedOptions,
            'correct_answer' => $r['correct_answer'],
            'explanation' => $r['explanation']
        ];
    }
    
    return $finalQuestions;
    } // End of Material=0 block logic replacements logic optimization checks
    
    // Wait, the original code had `if ($materialId === 0) { return [...] }`
    // I will replace that entire block.

    
    // 1. Check if questions already exist
    $stmt = $pdo->prepare("SELECT * FROM test_questions WHERE material_id = ? AND difficulty = ?");
    $stmt->execute([$materialId, $difficulty]);
    $existing = $stmt->fetchAll();
    
    if (count($existing) >= 5) {
        return $existing;
    }

    // 2. Try AI Generation
    require_once __DIR__ . '/openrouter_handler.php';
    $instructions = defined('GLOBAL_TRAINING_INSTRUCTIONS') ? GLOBAL_TRAINING_INSTRUCTIONS : "";
    
    $generatedQuestions = [];

    if (!empty($instructions)) {
        // Simpler prompt for Mistral/smaller models
        $prompt = "Create 5 multiple choice questions based on the text below.\n";
        $prompt .= "Return ONLY valid JSON. No markdown. No other text.\n";
        $prompt .= "Format: [{\"question_text\": \"...\", \"options\": [\"A\", \"B\", \"C\", \"D\"], \"correct_answer\": \"The correct option text\", \"explanation\": \"...\"}]\n\n";
        $prompt .= "TEXT:\n" . mb_substr($instructions, 0, 4000); // Smaller context for speed/focus

        $system = "You are an API that outputs JSON only.";
        
        $response = callOpenRouter([['role' => 'user', 'content' => $prompt]], $system);
        
        if ($response) {
            $content = $response['choices'][0]['message']['content'] ?? '';
            // Aggressive cleanup
            $start = strpos($content, '[');
            $end = strrpos($content, ']');
            if ($start !== false && $end !== false) {
                $jsonStr = substr($content, $start, ($end - $start) + 1);
                $generatedQuestions = json_decode($jsonStr, true);
            }
        }
    }

    // 3. Fallback if AI failed or returned invalid JSON
    if (empty($generatedQuestions) || !is_array($generatedQuestions)) {
        error_log("AI Test Gen Failed. Using Fallback.");
        $generatedQuestions = [
            [
                'question_text' => 'What is the command to set your admin password?',
                'options' => ['setinfo _pw "password"', 'amx_password "password"', 'password "password"', 'admin_pass "password"'],
                'correct_answer' => 'setinfo _pw "password"',
                'explanation' => 'The strict command format is setinfo _pw "yourpassword".'
            ],
            [
                'question_text' => 'Which chat command is used to message ONLY admins?',
                'options' => ['say_team @', 'amx_chat', 'U@', 'Y@'],
                'correct_answer' => 'U@',
                'explanation' => 'Pressing U (team chat) and starting with @ sends a message to the admin chat.'
            ],
            [
                'question_text' => 'What is the punishment for "Wallhack"?',
                'options' => ['Kick', '5 minute ban', 'Permanent ban', 'Slay'],
                'correct_answer' => 'Permanent ban',
                'explanation' => 'Cheating offenses like Wallhack result in an immediate permanent ban.'
            ],
            [
                'question_text' => 'When should you use amx_slap on a camper?',
                'options' => ['Immediately', 'After 10 seconds', 'After 25 seconds', 'Never'],
                'correct_answer' => 'After 25 seconds',
                'explanation' => 'Campers should be warned/slapped only after 25 seconds of the round have passed.'
            ],
            [
                'question_text' => 'What command shows the last 10 players who disconnected?',
                'options' => ['amx_who', 'amx_last', 'amx_history', 'amx_disconnected'],
                'correct_answer' => 'amx_last',
                'explanation' => 'amx_last displays the connection details of the most recent disconnects.'
            ]
        ];
    }

    // 4. Save to DB
    $stmtInfo = $pdo->prepare("INSERT INTO test_questions (material_id, question_text, question_type, difficulty, options, correct_answer, explanation) VALUES (?, ?, 'mcq', ?, ?, ?, ?)");
    
    $finalQuestions = [];
    foreach ($generatedQuestions as $q) {
        if (!isset($q['question_text']) || !isset($q['options'])) continue;
        
        $optionsJson = json_encode($q['options']);
        // Ensure correct_answer is in options, if not, pick the first one as fallback logic or trust AI? 
        // Let's trust AI but sanitize.
        
        $stmtInfo->execute([
            $materialId, 
            $q['question_text'], 
            $difficulty, 
            $optionsJson, 
            $q['correct_answer'], 
            $q['explanation'] ?? ''
        ]);
        
        $q['id'] = $pdo->lastInsertId();
        $finalQuestions[] = $q;
    }
    
    return array_merge($existing, $finalQuestions);
}
function submitTestAttempt($traineeId, $materialId, $answers) {
    $pdo = getDB();
    $score = 0;
    $total = count($answers);
    $correctCount = 0;
    
    // Calculate Score
    foreach ($answers as $ans) {
        // Fetch correct answer
        $stmt = $pdo->prepare("SELECT correct_answer FROM test_questions WHERE id = ?");
        $stmt->execute([$ans['question_id']]);
        $q = $stmt->fetch();
        
        if ($q && trim(strtolower($q['correct_answer'])) == trim(strtolower($ans['answer']))) {
            $correctCount++;
        }
    }
    
    $percentage = ($total > 0) ? ($correctCount / $total) * 100 : 0;
    $status = 'completed'; // or 'failed' if pass mark? Let's just say completed.
    
    // Insert Attempt
    // If materialId is 0 (Global), resolve to real DB ID
    if ($materialId === 0 || $materialId === null) {
        $stmtM = $pdo->prepare("SELECT id FROM training_materials WHERE original_name = 'General Admin Certification'");
        $stmtM->execute();
        $realId = $stmtM->fetchColumn();
        if (!$realId) {
             // Create it if missing
             try {
                 $stmtI = $pdo->prepare("INSERT INTO training_materials (filename, original_name, file_path, upload_date, uploaded_by) VALUES ('global_cert', 'General Admin Certification', 'global_cert_path', NOW(), 1)");
                 $stmtI->execute();
                 $realId = $pdo->lastInsertId();
             } catch (Exception $e) {
                 // Fallback: Try with first user as uploader if 1 fails
                 $stmtU = $pdo->query("SELECT id FROM users LIMIT 1");
                 $uid = $stmtU->fetchColumn() ?: 1;
                 $stmtI = $pdo->prepare("INSERT INTO training_materials (filename, original_name, file_path, upload_date, uploaded_by) VALUES ('global_cert', 'General Admin Certification', 'global_cert_path', NOW(), ?)");
                 $stmtI->execute([$uid]);
                 $realId = $pdo->lastInsertId();
             }
        }
        $materialId = $realId;
    }

    $stmt = $pdo->prepare("INSERT INTO test_attempts (trainee_id, material_id, total_questions, correct_answers, score_percentage, skill_level, status, completed_at) VALUES (?, ?, ?, ?, ?, 'basic', ?, NOW())");
    $stmt->execute([$traineeId, $materialId, $total, $correctCount, $percentage, $status]);
    $attemptId = $pdo->lastInsertId();
    
    // Save detailed answers (Optional, skipped for brevity but plan mentioned it)
    $stmtAns = $pdo->prepare("INSERT INTO test_answers (attempt_id, question_id, trainee_answer, is_correct) VALUES (?, ?, ?, ?)");
    foreach ($answers as $ans) {
         // Re-check correctness for saving
         $stmtQ = $pdo->prepare("SELECT correct_answer FROM test_questions WHERE id = ?");
         $stmtQ->execute([$ans['question_id']]);
         $correct = (trim(strtolower($stmtQ->fetchColumn())) == trim(strtolower($ans['answer'])));
         
         $stmtAns->execute([$attemptId, $ans['question_id'], $ans['answer'], $correct]);
    }
    
    return ['success' => true, 'score' => $percentage, 'attempt_id' => $attemptId];
}
?>
