<?php
// trainee/dashboard.php
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/includes/db.php';
require_once __DIR__ . '/includes/trainer_bot_functions.php';

$traineeId = $_SESSION['trainee_id'];
$activeSession = getActiveSession($traineeId);
// $materials = getAllTrainingMaterials(); // Removed as we use Global Training now
$testHistory = getTraineeTestHistory($traineeId);

include 'header.php';
?>

<div class="row g-4">
    <div class="col-12">
        <h2 class="fw-bold text-white mb-2">Welcome back, <?php echo htmlspecialchars($_SESSION['trainee_nick']); ?></h2>
        <p class="text-secondary">Ready to continue your admin training initialization?</p>
    </div>

    <!-- Active Training Card -->
    <div class="col-md-8">
        <?php if($activeSession): ?>
        <div class="trainee-card border-accent h-100 position-relative overflow-hidden">
            <div class="position-absolute top-0 end-0 p-3 opacity-10">
                <i class="bi bi-cpu-fill display-1 text-accent"></i>
            </div>
            <h4 class="fw-bold text-white mb-3">Active Session in Progress</h4>
            
            <div class="d-flex align-items-center mb-4">
                <div class="me-3">
                    <i class="bi bi-file-earmark-pdf fs-1 text-white opacity-50"></i>
                </div>
                <div>
                    <h5 class="fw-bold text-white mb-1"><?php echo htmlspecialchars($activeSession['original_name']); ?></h5>
                    <div class="progress" style="width: 200px; height: 6px; background: rgba(255,255,255,0.1);">
                        <div class="progress-bar bg-accent" style="width: <?php echo $activeSession['progress_percentage']; ?>%"></div>
                    </div>
                    <small class="text-accent"><?php echo $activeSession['progress_percentage']; ?>% Complete</small>
                </div>
            </div>
            
            <?php if($activeSession['progress_percentage'] >= 100): ?>
            <a href="test.php?session_id=<?php echo $activeSession['id']; ?>" class="btn btn-success px-5 py-2 fw-bold animate-pulse">
                <i class="bi bi-award-fill me-1"></i> TAKE FINAL EXAM
            </a>
            <?php else: ?>
            <a href="chat.php" class="btn btn-prof btn-prof-primary px-5 py-2">
                <i class="bi bi-play-fill me-1"></i> RESUME TRAINING
            </a>
            <div class="mt-2 text-secondary small"><i class="bi bi-lock-fill me-1"></i> Exam Locked until 100%</div>
            <?php endif; ?>
        </div>
        <?php else: ?>
        <div class="trainee-card h-100 d-flex flex-column justify-content-center text-center py-5">
            <i class="bi bi-pause-circle fs-1 text-secondary mb-3"></i>
            <h4 class="fw-bold text-white">No Active Session</h4>
            <p class="text-secondary small mb-4">Select a training module below to begin your instruction.</p>
        </div>
        <?php endif; ?>
    </div>

    <!-- Stats / Profile -->
    <div class="col-md-4">
        <div class="trainee-card h-100">
            <h6 class="text-secondary text-uppercase fw-bold mb-4" style="font-size: 0.7rem;">Your Status</h6>
            
            <div class="d-flex justify-content-between mb-3 p-3 rounded-3" style="background: rgba(0,0,0,0.2);">
                <span class="text-white fw-bold">Completed Tests</span>
                <span class="text-accent fw-bold"><?php echo count($testHistory); ?></span>
            </div>
            
            <div class="d-flex justify-content-between mb-3 p-3 rounded-3" style="background: rgba(0,0,0,0.2);">
                <span class="text-white fw-bold">Avg Score</span>
                <?php 
                    $avg = 0;
                    if(count($testHistory) > 0) {
                        $sum = 0;
                        foreach($testHistory as $th) $sum += $th['score_percentage'];
                        $avg = round($sum / count($testHistory), 1);
                    }
                ?>
                <span class="<?php echo $avg >= 70 ? 'text-success' : 'text-warning'; ?> fw-bold"><?php echo $avg; ?>%</span>
            </div>
        </div>
    </div>
                <!-- Global Training Module -->
                <div class="col-12">
                    <div class="row g-3">
                         <div class="col-12">
                            <h5 class="fw-bold mb-3 text-white"><i class="bi bi-collection text-warning me-2"></i> Available Training</h5>
                         </div>

                         <!-- Single Global Item -->
                         <div class="col-md-6 col-lg-4">
                            <div class="prof-card p-4 h-100 d-flex flex-column" style="background: var(--surface-color); border-left: 4px solid var(--accent-color);">
                                <div class="mb-3">
                                    <div class="d-flex justify-content-between align-items-start">
                                        <h5 class="fw-bold text-white mb-1">General Admin Training</h5>
                                        <span class="badge bg-accent bg-opacity-10 text-accent">Official</span>
                                    </div>
                                    <small class="text-secondary">Comprehensive guide for all DSGC server administrators.</small>
                                </div>
                                <div class="mt-auto">
                                    <button onclick="startSession(0)" class="btn btn-prof btn-prof-primary w-100">
                                        <i class="bi bi-play-fill me-2"></i> Start Training
                                    </button>
                                </div>
                            </div>
                         </div>
                    </div>
                </div>

                <!-- Test History (Unchanged) -->
    <?php if(!empty($testHistory)): ?>
    <div class="col-12 mt-4">
        <h5 class="fw-bold text-white mb-3">Recent Test Results</h5>
        <div class="trainee-card p-0 overflow-hidden">
            <table class="table table-dark table-hover mb-0" style="background: transparent;">
                <thead>
                    <tr class="text-secondary small text-uppercase">
                        <th class="ps-4">Date</th>
                        <th>Module</th>
                        <th>Score</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach(array_slice($testHistory, 0, 5) as $th): ?>
                    <tr>
                        <td class="ps-4"><?php echo date('M d', strtotime($th['started_at'])); ?></td>
                        <td><?php echo htmlspecialchars($th['material_name']); ?></td>
                        <td class="<?php echo $th['score_percentage']>=70?'text-success':'text-danger'; ?> fw-bold"><?php echo $th['score_percentage']; ?>%</td>
                        <td><?php echo $th['status']; ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php endif; ?>

</div>

<script>
function startSession(id) {
    const form = document.createElement('form');
    form.method = 'POST';
    form.action = 'chat.php';
    
    const inputAction = document.createElement('input');
    inputAction.type = 'hidden';
    inputAction.name = 'action';
    inputAction.value = 'start_new';
    
    const inputId = document.createElement('input');
    inputId.type = 'hidden';
    inputId.name = 'material_id';
    inputId.value = id; // Unused but kept for structure
    
    form.appendChild(inputAction);
    form.appendChild(inputId);
    document.body.appendChild(form);
    form.submit();
}
</script>
<?php include 'footer.php'; ?>
