<?php
// trainee/chat.php
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/includes/db.php';
require_once __DIR__ . '/includes/trainer_bot_functions.php';

$traineeId = $_SESSION['trainee_id'];

// Handle New Session Start from Dashboard
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'start_new') {
    // material_id is now ignored/optional for global training
    $newSessionId = startTrainingSession($traineeId, 0);
    header("Location: chat.php");
    exit;
}

$session = getActiveSession($traineeId);
if (!$session) {
    header("Location: dashboard.php");
    exit;
}

// Initial Chat History
$history = getSessionChatHistory($session['id'], 50);

include 'header.php';
?>

<div class="row justify-content-center">
    <div class="col-lg-8 col-xl-7">
        <!-- Progress Header -->
        <div class="d-flex justify-content-between align-items-center mb-3 text-white">
            <div>
                 <small class="text-secondary text-uppercase fw-bold ls-wide">Active Module</small>
                 <h5 class="fw-bold mb-0"><?php echo htmlspecialchars($session['original_name']); ?></h5>
            </div>
            <div class="text-end">
                <span class="badge bg-accent text-dark fw-bold mb-1">
                    <?php echo $session['progress_percentage']; ?>% Complete
                </span>
                <?php if($session['progress_percentage'] >= 100): ?>
                <a href="test.php?session_id=<?php echo $session['id']; ?>" class="btn btn-sm btn-success d-block fw-bold animate-pulse" style="font-size: 0.65rem; padding: 2px 5px;">TAKE TEST</a>
                <?php else: ?>
                <button class="btn btn-sm btn-outline-secondary d-block disabled" style="font-size: 0.65rem; padding: 2px 5px;" title="Complete training to unlock"><i class="bi bi-lock-fill"></i> TEST LOCKED</button>
                <?php endif; ?>
            </div>
        </div>

        <!-- Chat Container -->
        <div class="chat-container">
            <div class="chat-header d-flex justify-content-between align-items-center">
                <div class="d-flex align-items-center">
                     <div class="rounded-circle bg-accent d-flex align-items-center justify-content-center me-2" style="width: 32px; height: 32px;">
                         <i class="bi bi-robot text-dark"></i>
                     </div>
                     <span class="fw-bold text-white small">Trainer Bot</span>
                </div>
                <!-- Controls -->
                <div>
                     <button class="btn btn-link text-secondary p-0" title="Clear Chat"><i class="bi bi-trash"></i></button>
                </div>
            </div>

            <div class="chat-messages" id="chatArea">
                <!-- Welcome / History -->
                <?php if(empty($history)): ?>
                    <div class="chat-message chat-message-bot">
                        Hello <?php echo htmlspecialchars($_SESSION['trainee_nick']); ?>! I am loaded and ready to instruct you on <strong><?php echo htmlspecialchars($session['original_name']); ?></strong>. Are you ready to begin?
                    </div>
                <?php else: ?>
                    <?php foreach($history as $msg): ?>
                        <div class="chat-message chat-message-<?php echo htmlspecialchars($msg['sender']); ?>" data-id="<?php echo $msg['id']; ?>">
                            <?php echo nl2br(htmlspecialchars($msg['message'])); ?>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
                
                <div class="typing-indicator d-none ms-3 mb-3" id="typingIndicator">
                    <span></span><span></span><span></span>
                </div>
            </div>

            <div class="chat-input-area">
                <form id="chatForm" class="d-flex gap-2">
                    <input type="hidden" id="sessionId" value="<?php echo $session['id']; ?>">
                    <input type="text" class="chat-input" id="msgInput" placeholder="Type your response..." autocomplete="off">
                    <button type="submit" class="btn btn-prof btn-prof-primary px-4">
                        <i class="bi bi-send-fill"></i>
                    </button>
                </form>
            </div>
        </div>
        
        <div class="text-center mt-3">
             <a href="dashboard.php" class="text-secondary small text-decoration-none"><i class="bi bi-arrow-left me-1"></i> Return to Dashboard</a>
        </div>
    </div>
    
    <!-- Info Panel / Quick Reference (Optional) -->
    <div class="col-lg-4 col-xl-3 d-none d-lg-block">
        <div class="prof-card p-4 h-100 bg-opacity-10" style="background: rgba(0,0,0,0.2);">
             <h6 class="text-white fw-bold mb-3"><i class="bi bi-info-circle me-2 text-accent"></i>Quick Tips</h6>
             <ul class="list-unstyled text-secondary small">
                 <li class="mb-2">• Ask clarifying questions if you don't understand.</li>
                 <li class="mb-2">• The bot will simulate scenarios.</li>
                 <li class="mb-2">• Type "Ready" to advance to the next topic.</li>
                 <li class="mb-2">• You can take the test at any time, but completing the training is recommended.</li>
             </ul>
        </div>
    </div>
</div>

<script src="js/trainer_chat.js"></script>

<?php include 'footer.php'; ?>
